const express = require('express');
const next = require('next');

const dev = process.env.NODE_ENV !== 'production';
const app = next({ dev });
const handle = app.getRequestHandler();

// Phusion Passenger sets the PORT environment variable
const port = process.env.PORT || 3000;

app.prepare().then(() => {
  const server = express();

  // Parse JSON bodies (as sent by API clients)
  server.use(express.json());

  // Custom API routes can be defined here if needed, 
  // but Next.js API routes (/pages/api) are usually sufficient.

  // Handle all other requests with Next.js
  server.all('*', (req, res) => {
    return handle(req, res);
  });

  server.listen(port, (err) => {
    if (err) throw err;
    console.log(`> Ready on http://localhost:${port}`);
  });
});
